/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.sysinfo;

import com.ibm.hwmca.base.sysinfo.SysInfoConstants;
import com.ibm.hwmca.base.sysinfo.SysInfoErrorIds;
import com.ibm.hwmca.base.sysinfo.SysInfoFrameBean;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.sysinfo.SysInfo;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptor;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorData;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class SysInfoTasklet
extends HwmcaPanelTasklet
implements SysInfoErrorIds,
SysInfoConstants {
    private static final String TRACE_MASKT = "HSYITKLT";
    private static final String TRACE_MASKF = "HSYITKLF";
    private static final String TRACE_MASKD = "HSYITKLD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-53, "SysInfoTasklet");
    private static final String TWR_PACKAGE_NAME = "com.ibm.hwmca.fw.managed";
    private static final String TWR_CLASS_NAME = "Tower";
    private ArrayList targetList = new ArrayList();
    private ArrayList taskletList = new ArrayList();
    int targetCount;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$sysinfo$SysInfo;

    public void logException(Throwable throwable) {
        new FrameworkLog(logInfo, 56, throwable).log();
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> SysInfoTasklet.service()");
        Object requestData = null;
        int paneCount = 0;
        boolean readyCount = false;
        Trace.trace(TRACE_MASKT, "PanelTaskletRequest = " + request);
        if (request.isInitialRequest()) {
            Trace.trace(TRACE_MASKT, "SysInfoTasklet PanelTaskletRequest = InitialRequest");
            PresentationTaskParms parms = null;
            parms = this.getPresentationTaskParms();
            if (parms != null) {
                ObjectId[] targetIds = parms.getTargetIds();
                if (targetIds != null) {
                    this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "sysinfo.progress.title"), new LocalizableText(BaseTextBundle.getBundleName(), "sysinfo.mo.progress.text"));
                    this.getManagedObjectTargets(targetIds);
                } else {
                    this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "sysinfo.progress.title"), new LocalizableText(BaseTextBundle.getBundleName(), "sysinfo.tower.progress.text"));
                    this.getTowerTargets();
                }
                SysInfoFrameBean frameBean = new SysInfoFrameBean();
                frameBean.setBeanName("SysInfoFrameBean");
                String panelName = this.taskletList.size() > 1 ? "SystemInfoTPanel" : "SystemInfoTPanel1";
                DisplayAreaDescriptorData frame = new DisplayAreaDescriptorData("com.ibm.hwmca.base.sysinfo.res.SystemInfoRes", panelName, frameBean, new LocalizableText(BaseTextBundle.getBundleName(), "sysinfo.progress.title"), "My Frame:" + this.taskletId);
                DisplayAreaDescriptor[] delegate = new DisplayAreaDescriptorDelegate[this.taskletList.size()];
                HwmcaObject targetObject = null;
                ObjectId targetObjectId = null;
                int i = 0;
                Iterator iterator = this.taskletList.iterator();
                while (iterator.hasNext()) {
                    String tempString = (String)iterator.next();
                    targetObject = (HwmcaObject)this.targetList.get(i);
                    targetObjectId = targetObject.getObjectId();
                    HashMap<String, ObjectId> targetMap = new HashMap<String, ObjectId>();
                    targetMap.put("TARGET_OBJECT_ID", targetObjectId);
                    delegate[i] = new DisplayAreaDescriptorDelegate(tempString, targetMap);
                    Trace.trace(TRACE_MASKT, "DisplayAreaDescriptorDelegate: " + tempString);
                    ((DisplayAreaDescriptorDelegate)delegate[i]).setMountPoint("SystemInfoTPane");
                    ++i;
                }
                paneCount = i;
                Trace.trace(TRACE_MASKF, "Number of panes to display is " + paneCount);
                this.destroyBusyDialog();
                response.replace(frame, delegate);
            } else {
                Trace.trace(TRACE_MASKF, "PresentationTaskParms is null");
                HException hexc = new HException("PresentationTaskParms is null");
                new FrameworkLog(logInfo, 57, hexc).log();
                this.destroyBusyDialog();
                response.terminate();
            }
        } else if (request.isDisposed() || request.isCanceled()) {
            Trace.trace(TRACE_MASKT, "Terminating the tasklet");
            response.terminate();
        } else {
            Trace.trace(TRACE_MASKD, "Issuing noAction Response ");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- SysInfoTasklet.service()");
    }

    public void getTowerTargets() {
        Trace.trace(TRACE_MASKT, "-> SysInfoTasklet.getTowerTargets()");
        ClassId cId = new ClassId(TWR_PACKAGE_NAME, TWR_CLASS_NAME);
        Set towerInventory = ManagedObjectManager.getManagedObjectManager().getInventory(cId);
        Trace.trace(TRACE_MASKF, "Tower inventory size: " + towerInventory.size());
        this.targetCount = 0;
        Iterator iterator = towerInventory.iterator();
        while (iterator.hasNext()) {
            HwmcaObject obj = (HwmcaObject)iterator.next();
            try {
                Object towerImpl = ((Tower)obj).getInterfaceImpl(SysInfoConstants.INTERFACE_CLASS);
                if (towerImpl == null) continue;
                Trace.trace(TRACE_MASKF, "Found a tower implementation of sysinfo = " + towerImpl);
                SysInfo implClass = (SysInfo)towerImpl;
                String taskletName = implClass.getSysInfoTaskletName();
                if (taskletName != null) {
                    Trace.trace(TRACE_MASKF, "tasklet name = " + taskletName);
                    this.taskletList.add(this.targetCount, taskletName);
                    this.targetList.add(this.targetCount, (Tower)obj);
                    ++this.targetCount;
                    continue;
                }
                Trace.trace(TRACE_MASKF, "Could not find a tasklet name for = " + towerImpl);
                throw new TaskletException("Could not find a tasklet name for = " + towerImpl);
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, "SysInfoTasklet.getTowerSysInfo exception: " + exc);
                new FrameworkLog(logInfo, 58, exc).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<- SysInfoTasklet.getTowerTargets()");
    }

    public void getManagedObjectTargets(ObjectId[] targetIds) {
        int i = 0;
        Trace.trace(TRACE_MASKT, "-> SysInfoTasklet.getManagedObjects(ObjectId[] )");
        this.targetCount = 0;
        i = 0;
        while (i < targetIds.length) {
            block9: {
                HwmcaObject obj = this.getObjectForId(targetIds[i]);
                Trace.trace(TRACE_MASKD, "In loop to find objects via targetIds ");
                Trace.trace(TRACE_MASKD, "targetId = " + targetIds[i]);
                Trace.trace(TRACE_MASKD, "object  = " + obj);
                if (obj != null) {
                    if (obj instanceof ManagedObject) {
                        Trace.trace(TRACE_MASKD, "obj is MO calling getClssInterfaceImpl");
                        ManagedObject moObj = (ManagedObject)obj;
                        Object moImpl = moObj.getInterfaceImpl(class$com$ibm$hwmca$fw$sysinfo$SysInfo == null ? SysInfoTasklet.class$("com.ibm.hwmca.fw.sysinfo.SysInfo") : class$com$ibm$hwmca$fw$sysinfo$SysInfo);
                        Trace.trace(TRACE_MASKD, "MO Impl is " + moImpl);
                        if (moImpl != null) {
                            Trace.trace(TRACE_MASKF, "Found an implementation of sysinfo = " + moImpl);
                            try {
                                SysInfo implClass = (SysInfo)moImpl;
                                String taskletName = implClass.getSysInfoTaskletName();
                                if (taskletName != null) {
                                    this.taskletList.add(this.targetCount, taskletName);
                                    this.targetList.add(this.targetCount, obj);
                                    Trace.trace(TRACE_MASKD, "targets[" + this.targetCount + "] is a managedObject = " + obj);
                                    Trace.trace(TRACE_MASKF, "Found an implementation of sysinfo = " + moImpl);
                                    ++this.targetCount;
                                    break block9;
                                }
                                Trace.trace(TRACE_MASKF, "Could not find a tasklet name for = " + moImpl);
                                throw new TaskletException("Could not find a tasklet name for = " + moImpl);
                            }
                            catch (Exception exc) {
                                Trace.trace(TRACE_MASKF, "SysInfoTasklet.getSysInfoTaskletName exception: " + exc);
                                new FrameworkLog(logInfo, 61, exc).log();
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "SysInfoTasklet.getClassInterfaceImpl(targetId) exception");
                            HException hexc = new HException("getClassInterfaceImpl(targetId) exception");
                            FrameworkLog interfaceLog = new FrameworkLog(logInfo, 60, hexc);
                            interfaceLog.log(FrameworkLogAttributes.INFO_LOG);
                        }
                    }
                } else {
                    throw new IllegalArgumentException("ObjectId does not correspond to a target: " + targetIds[i]);
                }
            }
            ++i;
        }
        Trace.trace(TRACE_MASKD, "back from getting targets");
        Trace.trace(TRACE_MASKD, "# of targets = " + this.targetCount);
        Trace.trace(TRACE_MASKT, "<- SysInfoTasklet.getManagedObjects(ObjectId[])");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

